using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace PI.ZB.N1200.ELearning.WinForms.Dialog
{
    public partial class ProgressForm : PI.FM.N000.Base.WinForms.Controls.Form
    {
        public ProgressForm()
        {
            InitializeComponent();
            CancelProgress = false;
            StepSize = 1;
            MaxCount = 10;
        }

        public bool CancelProgress { get; set; }
        public int MaxCount { get; set; }
        public int StepSize { get; set; }
        public DateTime StartTime = DateTime.MinValue;

        public void Init()
        {
            StartTime = DateTime.Now;
            CancelProgress = false;
            this._pbar.Minimum = 0;
            this._pbar.Maximum = MaxCount;
            this._pbar.Step = StepSize;
            this._pbar.Value = this._pbar.Minimum;

            this._lblProgress.Text = String.Format("{0}/{1}", 0, MaxCount);
            this._lblProgress.Refresh();
        }

        public void UpdateProgress(string Akcja)
        {
            this._pbar.PerformStep();

            TimeSpan _durationTime = DateTime.Now - StartTime;

            this._gLabelStartTime.Text = StartTime.ToLongTimeString();
            this._gLabelDurationTime.Text = Gemini.Utility.Normalize.DurationTimeFormat(StartTime, DateTime.Now);

            this._lblProgress.Text = String.Format("{0}/{1}", this._pbar.Value, MaxCount);
            this._gLabelDurationTime.Text = Gemini.Utility.Normalize.DurationTimeFormat(StartTime, DateTime.Now);
            this._lblProgress.Refresh();

            this._lblAkcja.Text = Akcja;
            this._lblAkcja.Refresh();

            Application.DoEvents();
        }

        public void AppendMessage(string Message)
        {
            _memInfo.Text = string.Format("{0}\r\n{1}", _memInfo.Text, Message);
        }

        private void _btnAnuluj_Click(object sender, EventArgs e)
        {
            this._btnAnuluj.Enabled = false;
            if (PI.FM.N000.Base.WinForms.MsgBox.QuestionYesNo(this.Environment, "Czy anulowa operacj?"))
            {
                CancelProgress = true;
            }
            else
            {
                CancelProgress = false;
                this._btnAnuluj.Enabled = true;
                this._btnAnuluj.Refresh();
            }
            Application.DoEvents();
        }


        public class Sync
        {
            private List<string> _messages = new List<string>();
            private ProgressForm _progressForm = null;
            public void Start(PI.ZB.N1200.ELearning.BL.ZSBELearning ZSBELearning)
            {
                _progressForm = new ProgressForm();
                _progressForm.TopMost = true;

                ZSBELearning.APISyncAll(StartSync, ProgressSync, EndSync);
            }
            
            private bool StartSync(int Count)
            {
                _progressForm.StepSize = 1;
                _progressForm.MaxCount = Count;
                _progressForm.Init();
                _progressForm.Show();
                return true;
            }

            private bool ProgressSync(PI.FM.N000.Base.BL.BO.Base Object, int Index, bool Sucess, string Message)
            {
                if (!Sucess)
                {
                    _progressForm.AppendMessage(Message);
                }
                _progressForm.UpdateProgress("Synchronizacja: " + Object.GetType().Name);
                return !_progressForm.CancelProgress;
            }

            private bool EndSync()
            {
                _progressForm.Close();
                _progressForm = null;
                return true;
            }
        }
    }
}